<?php

// تحديد المعلومات اللازمة
$email = "mtc9afd-01@makamat.com"; // يمكنك تغييرها بالبريد الإلكتروني الخاص بك
$password = "mtc9afd-2023"; // يمكنك تغييرها بكلمة مرورك

// بناء البيانات المرسلة كنص متشفر
$postData = json_encode(array(
    'email' => $email,
    'password' => $password
));

// بناء الطلب للحصول على رمز التميز
$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => "https://mtc9afd-01.azurewebsites.net/api/Auth/login", // يمكننا استبدال "{{domain}}" بالمعلومات المحددة في الطلب
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => $postData,
    CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "cache-control: no-cache",
        "Permissions-Policy: interest-cohort=()" // تجاهل الرأس المشكل
    ),
    CURLOPT_SSL_VERIFYHOST => false, // تعطيل التحقق من صحة الشهادة
    CURLOPT_SSL_VERIFYPEER => false, // تعطيل التحقق من الشهادة
));

// إرسال الطلب والحصول على الرد
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo "خطأ في الاتصال بالخادم: " . $err;
} else {
    // تحويل الرد إلى مصفوفة جسون
    $responseArray = json_decode($response, true);

    // استخراج الرمز المميز من الرد
    $token = $responseArray['token'];

    // عرض الرمز المميز
    echo "الرمز المميز: " . $token . "<br>";

    // بناء البيانات المطلوبة للطلب GET
    $startTime = "2024-04-27T14:51:04.929Z";
    $endTime = "2024-04-28T14:51:04.929Z";

    // بناء الطلب الجديد للحصول على بيانات RFID
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://mtc9afd-01.azurewebsites.net/api/RFIDScanData/timeperiod?startTime=$startTime&endTime=$endTime",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer $token",
            "Content-Type: application/json", // إضافة رأس لتحديد نوع الوسائط
            "cache-control: no-cache",
            "Permissions-Policy: interest-cohort=()" // تجاهل الرأس المشكل
        ),
        CURLOPT_SSL_VERIFYHOST => false, // تعطيل التحقق من صحة الشهادة
        CURLOPT_SSL_VERIFYPEER => false, // تعطيل التحقق من الشهادة
    ));

    // إرسال الطلب والحصول على الرد
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo "خطأ في الاتصال بالخادم: " . $err;
    } else {
        // تحويل الاستجابة إلى مصفوفة جسون
        $responseData = json_decode($response, true);

        // التحقق من وجود البيانات في الاستجابة
        if (!empty($responseData)) {
            // عرض البيانات بشكل صحيح
            echo "البيانات:<br>";
            foreach ($responseData as $data) {
                echo "rfidScanDataId: " . $data['rfidScanDataId'] . "<br>";
                echo "epc: " . $data['epc'] . "<br>";
                echo "tagNumber: " . $data['tagNumber'] . "<br>";
                echo "assetBarcode: " . $data['assetBarcode'] . "<br>";
                echo "operator: " . $data['operator'] . "<br>";
                echo "assetType: " . $data['assetType'] . "<br>";
                echo "readTimestamp: " . $data['readTimestamp'] . "<br>";
                echo "region: " . $data['region'] . "<br>";
                echo "city: " . $data['city'] . "<br>";
                echo "locationSpecifier: " . $data['locationSpecifier'] . "<br>";
                echo "locationTag1: " . $data['locationTag1'] . "<br>";
                echo "locationTag2: " . $data['locationTag2'] . "<br>";
                echo "latitude: " . $data['latitude'] . "<br>";
                echo "longitude: " . $data['longitude'] . "<br>";
                echo "operation: " . $data['operation'] . "<br>";
                echo "scanState: " . $data['scanState'] . "<br><br>";
            }
        } else {
            echo "لا توجد بيانات لعرضها.";
        }
    }
}
?>
